## PATH is the shell search path. Use another name.

### Problematic code:

```sh
PATH=/my/dir
cat "$PATH/myfile"
```

### Correct code:

Good practice: always use lowercase for unexported variables.

```sh
path=/my/dir
cat "$path/myfile"
```

Bad practice: use another uppercase name.

```sh
MYPATH=/my/dir
cat "$MYPATH/myfile"
```

### Rationale:

`PATH` is where the shell looks for the commands it executes. By inadvertently overwriting it, the shell will be unable to find commands (like `cat` in this case).

You get this warning when ShellCheck suspects that you didn't meant to overwrite it (because it's a single path with no path separators).

Best shell scripting practice is to always use lowercase variable names to avoid accidentally overwriting exported and internal variables.

### Exceptions

If you're aware of the above and really do want to set your shell search path to `/my/dir`, you can ignore this warning.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2123)

