## Brace expansions and globs are literal in assignments. Quote it or use an array.

### Problematic code:

```sh
foo={1..9}
echo $foo
```

### Correct code:

```sh
foo=( {1..9} )
echo "${foo[@]}"
```

### Rationale:

`echo *.png {1..9}` expands to all png files and numbers from 1 to 9, but `var=*.png` or `var={1..9}` will just assign the literal strings `'*.png'` and `'{1..9}'`.

To make the variable contain all png files or 1 through 9, use an array as demonstrated.

If you intended to assign these values as literals, quote them (e.g. `var="*.png"`).

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2125)

