## Expanding an array without an index only gives the first element.

### Problematic code:

```sh
myarray=(foo bar)
for f in $myarray
do
  cat "$f"
done
```

### Correct code:

```sh
myarray=(foo bar)
for f in "${myarray[@]}"
do
  cat "$f"
done
```

### Rationale:

When referencing arrays, `$myarray` is equivalent to `${myarray[0]}` -- it results in only the first of multiple elements.

To get all elements as separate parameters, use the index `@` (and make sure to double quote). In the example, `echo "${myarray[@]}"` is equivalent to `echo "foo" "bar"`.

To get all elements as a single parameter, concatenated by the first character in `IFS`, use the index `*`. In the example, `echo "${myarray[*]}"` is equivalent to `echo "foo bar"`.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2128)

