##  Word is on the form "A"B"C" (B indicated). Did you mean "ABC" or "A\\"B\\"C"?

### Problematic code:

```sh
echo "<img src="foo.png" />" > file.html
```

or

```sh
export "var"="42"
```

### Correct code:

```sh
echo "<img src=\"foo.png\" />" > file.html
```

or

```sh
export "var=42"
```


### Rationale:

This warning triggers when an unquoted literal string is found suspiciously sandwiched between two double quoted strings.

This usually indicates one of:

- quotes that were supposed to be nested, and therefore need to be escaped (like the `<img>` example)
- quotes that are just plain unnecessary (like the `export` example).

Without escaping, the inner two quotes of the sandwich (the end quote of the first section and the start quote of the second section) are no-ops. The following two statements are identical, so the quotes that were intended to be part of the html output are instead removed:

```sh
echo "<img src="foo.png" />" > file.html
echo "<img src=foo.png />" > file.html
```

Similarly, these statements are identical, but work as intended:

```sh
export "var"="42"
export "var=42"
```

### Exceptions

If you know that the quotes are ineffectual but you prefer it stylistically, you can ignore this message.

It's common not to realize that double quotes can span multiple elements, or to stylistically prefer to quote individual variables. For example, these statements are identical, but the first is laboriously and redundantly quoted:

```sh
http://"$user":"$password"@"$host"/"$path"
"http://$user:$password@$host/$path"
```

When ShellCheck detects the first style (i.e. the double quotes include only a single element each), it will suppress the warning.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2140)

