## Remove $/${} for numeric index, or escape it for string.

### Problematic code:

```sh
# Regular array
index=42
echo $((array[$index]))
```

or

```sh
# Associative array
index=banana
echo $((array[$index]))
```

### Correct code:

```
# Regular array
index=42
echo $((array[index]))
```

or

```sh
# Associative array
index=banana
echo $((array[\$index]))
```

### Rationale:

For a numerically indexed array, the `$` is mostly pointless and can be removed like in [[SC2004]].

For associative arrays, the `$` should be escaped to avoid accidental dereferencing:

```sh
declare -A array
index='$1'
array[$index]=42
echo "$(( array[$index] ))"    # bash: array: bad array subscript
echo "$(( array[\$index] ))"   # 42
```

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2149)

