## Only one integer 0-255 can be returned. Use stdout for other data.

### Problematic code:

```sh
myfunc() {
  return foo bar
}
```

### Correct code:

```sh
myfunc() {
  echo foo
  echo bar
  return 0
}
```

### Rationale:

In bash, `return` can only be used to signal success or failure (0 = success, 1-255 = failure).

To return textual or multiple values from a function, write them to stdout and capture them with command substitution instead.

See [[SC2152]] for more information.

### Exceptions:

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2151)

