## This nested loop overrides the index variable of its parent.

And companion warning "This parent loop has its index variable overridden."

### Problematic code:

```sh
for((i=0; i<10; i++))
do
  for i in *
  do
    echo "$i"
  done
done
```

### Correct code:

```sh
for((i=0; i<10; i++))
do
  for j in *
  do
    echo "$j"
  done
done
```

### Rationale:

When nesting loops, especially arithmetic for loops, using the same loop variable can cause unexpected results.

In the problematic code, `i` will contain the last filename from the inner loop, which will be interpreted as a value in the next iteration out the outer loop. This results in either an infinite loop or a syntax error, depending on whether the last filename is a valid shell variable name.

In nested for-in loops, variable merely shadow each other and won't cause infinite loops or syntax errors, but reusing the variable name is rarely intentional.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2165)

