## 'time' is undefined for pipelines. time single stage or bash -c instead.

### Problematic code:

```sh
time foo | bar
```

### Correct code:

To time the most relevant stage:

```sh
foo | { time bar; }
```

To time everything in a pipeline:

```sh
time bash -c 'foo | bar'
```

Note that you can not use `time sh -c` to time an entire pipeline, because POSIX does not guarantee that anything other than the last stage is waited upon by the shell. 

### Rationale:

This behavior is explicitly left undefined [in POSIX](http://pubs.opengroup.org/onlinepubs/9699919799/utilities/time.html).

### Exceptions:

None. This warning is not emitted in `ksh` or `bash` where `time` is defined for pipelines.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2176)

