## Use array+=("item") to append items to an array.

### Problematic code:

```sh
var=(one two)
var+=three
```

### Correct code:

```sh
var=(one two)
var+=( three )
```
### Rationale:

It looks like you are trying to append a string to an array with `var+=string`. This instead appends to the first element of the array (equivalent to `var[0]+=three`).

In the problematic code, the array will therefore contain `onethree` `two`.

Instead, append an array to the array with `var+=( elements )`. This will append the new items to the array.

In the correct code, it will contain `one` `two` `three` as expected.

### Exceptions:

If ShellCheck mistakenly thinks the variable is an array when it's not (e.g. because the same name was used in a different context), you can ignore this error.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2179)

