## Quote arguments to unset so they're not glob expanded.

### Problematic code:

```sh
unset foo[index]
```

### Correct code:

```sh
unset 'foo[index]'
```
### Rationale:

Arguments to `unset` are subject to regular glob expansion. This is especially relevant when unsetting indices in arrays, where `[..]` is considered a glob character group.

In the problematic code, having a file called `food` in the current directory will result in `unset foo[index]` expanding to `unset food`, which will silently succeed without unsetting the element.

Quoting so that the `[..]` is passed literally to `unset` solves the issue.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2184)

