## Ash scripts will be checked as Dash. Add '# shellcheck shell=dash' to silence.

### Problematic code:

```sh
#!/bin/ash
echo "Hello World"
```

### Correct code:

```sh
#!/bin/ash
# shellcheck shell=dash
echo "Hello World"
```
### Rationale:

ShellCheck has no first class support for `ash`, but it does support its Debian fork `dash` and defaults to this whenever `ash` is specified.

Unfortunately, while the two are similar, they are not completely compatible. For example, `ash` supports `echo -e` but `dash` does not, so ShellCheck will incorrectly warn about it.

You can use a [[directive]] to let ShellCheck know you're aware of this problem.

### Exceptions:

None. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2187)

