## Use `[[ ]]` or quote arguments to -v to avoid glob expansion.

### Problematic code:

```sh
[ -v foo[0] ] 
```

### Correct code:

```sh
[ -v 'foo[0]' ]
```
### Rationale:

With `[`, arguments will undergo glob expansion. If a file `foo0` exists when the problematic code is run, it will check for the variable `foo0` instead of the array entry `foo[0]`. If there additionally exists a `foo1`, it will simply fail with an error.

Use `[[ ]]` or quote the argument.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2208)

