## Use 'false' instead of empty [/[[ conditionals.

### Problematic code:

```sh
if [ ]
then
  echo "Temporarily disabled"
fi
```

### Correct code:

```sh
if false
then
  echo "Temporarily disabled"
fi
```
### Rationale:

`[ ]` is a somewhat obscure way of expressing falsehood, and the behavior is likely intended to allow the incorrectly quoted command `[ $var ]` to still work when the variable is unset.

POSIX has a more descriptive command `false` for this.

### Exceptions:

None. This is a stylistic suggestion, and has no effect on how the script works.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2212)

