## This mv has no destination. Check the arguments.

### Problematic code:

```sh
mv "$file $dir"
```

### Correct code:

```sh
mv "$file" "$dir"
```
### Rationale:

ShellCheck found an `mv` command with a single parameter. This may be because the source and destination was accidentally merged into a single argument, or because the line was broken in an invalid way.

Fix the `mv` statement by correctly specifying both source and destination.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC2224)

