## Remove superfluous `(..)` around test command.

### Problematic code:

```sh
([ "$x" -gt 0 ]) && foo
```

### Correct code:

```sh
[ "$x" -gt 0 ] && foo
```

### Rationale:

You are wrapping a single test command in `(..)`, creating an unnecessary subshell. This serves no purpose, but is dramatically slower:

```
$ i=0; time while ( [ "$i" -lt 10000 ] ); do i=$((i+1)); done
real    0m6.998s
user    0m3.453s
sys     0m3.464s

$ i=0; time while [ "$i" -lt 10000 ]; do i=$((i+1)); done
real    0m0.055s
user    0m0.054s
sys     0m0.001s
```

Just delete the surrounding `(..)` since they serve no purpose and only slows the script down.

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2234)

