## Ensure the shebang uses the absolute path to the interpreter.

### Problematic code:

```sh
#!bin/sh
echo "Hello World"
```

### Correct code:

```sh
#!/bin/sh
echo "Hello World"
```

### Rationale:

The script's interpreter, as specified in the shebang, does not start with a `/`.

The interpreter should always be specified by absolute path to ensure that the script can be executed from any directory. When it's not, it's generally a typo like in the problematic example.

If you don't know where the interpreter is and you hoped to use `#! bash`, this is not an option. Use `/usr/bin/env` instead:

```sh
#!/usr/bin/env bash
echo "Hello World"
``` 

While not required by POSIX, `env` can essentially always be found in `/usr/bin` and will search the PATH for the specified executable.

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2239)

