## This shebang specifies a directory. Ensure the interpreter is a file.

### Problematic code:

```sh
#!/bin/sh/
echo "Hello World"
```

### Correct code:

```sh
#!/bin/sh
echo "Hello World"
```
### Rationale:

The shebang specifies which file to use as an interpreter, but probably due to some kind of typo, your script's interpreter ends in a `/`, indicating a directory.

Ensure it points to a valid executable filename.

### Exceptions:

None

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2246)

