
Nested code blocks can be used to create a new scope and restrict the visibility of the variables defined inside it. Using this feature in a method typically indicates that the method has too many responsibilities, and should be refactored into smaller methods.

## Noncompliant Code Example


    public void Evaluate()
    {
        /* ... */
        {     // Noncompliant - nested code block '{' ... '}'
              int a = stack.pop();
              int b = stack.pop();
              int result = a + b;
              stack.push(result);
        }
        /* ... */
    }


## Compliant Solution


    public void Evaluate()
    {
        /* ... */
        StackAdd();
        /* ... */
    }
    
    private void StackAdd()
    {
          int a = stack.pop();
          int b = stack.pop();
          int result = a + b;
          stack.push(result);
    }


## Exceptions

The usage of a code block after a "case" is allowed for this rule.
