
The requirement for a final `default` clause is defensive programming. The clause should either take appropriate action, or contain a suitable comment as to why no action is taken. Even when the `switch` covers all current values of an `enum`, a `default` case should still be used because there is no guarantee that the `enum` won't be extended.

## Noncompliant Code Example


    int foo = 42;
    switch (foo) // Noncompliant
    {
      case 0:
        Console.WriteLine("foo = 0");
        break;
      case 42:
        Console.WriteLine("foo = 42");
        break;
    }


## Compliant Solution


    int foo = 42;
    switch (foo) // Compliant
    {
      case 0:
        Console.WriteLine("foo = 0");
        break;
      case 42:
        Console.WriteLine("foo = 42");
        break;
      default:
        throw new InvalidOperationException("Unexpected value foo = " + foo);
    }


## See

- [MITRE, CWE-478](http://cwe.mitre.org/data/definitions/478.html) - Missing Default Case in Switch Statement
- [CERT, MSC01-C.](https://www.securecoding.cert.org/confluence/x/YgE) - Strive for logical completeness

