
There is no reason to re-assign a variable to itself. Either this statement is redundant and should be removed, or the re-assignment is a mistake and some other value or variable was intended for the assignment instead.

## Noncompliant Code Example


    public void SetName(string name)
    {
      name = name;
    }


## Compliant Solution


    public void SetName(string name)
    {
      this.name = name;
    }


## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed

