
Unnecessary casting expressions make the code harder to read and understand.

## Noncompliant Code Example


    public int Example(int i)
    {
        return (int) (i + 42); // Noncompliant
    }
    
    public IEnumerable&lt;int&gt; ExampleCollection(IEnumerable&lt;int&gt; coll)
    {
        return coll.Reverse().OfType&lt;int&gt;(); // Noncompliant
    }


## Compliant Solution


    public int Example(int i)
    {
        return i + 42;
    }
    
    public IEnumerable&lt;int&gt; ExampleCollection(IEnumerable&lt;int&gt; coll)
    {
        return coll.Reverse();
    }


## Exceptions

Issues are not raised against C# 7.1 `default` literal.


    bool b = (bool)default; // Doesn't raise an issue

