
An inheritance list entry is redundant if:

- It is `Object` - all classes extend `Object` implicitly.
- It is `int` for an `enum`
- It is a base class of another listed inheritance.


Such redundant declarations should be removed because they needlessly clutter the code and can be confusing.

## Noncompliant Code Example


    public class MyClass : Object  // Noncompliant
    
    enum MyEnum : int  // Noncompliant


## Compliant Solution


    public class MyClass
    
    enum MyEnum

