
When division is performed on `int`s, the result will always be an `int`. You can assign that result to a `double`, `float` or `decimal` with automatic type conversion, but having started as an `int`, the result will likely not be what you expect. If the result of `int` division is assigned to a floating-point variable, precision will have been lost before the assignment. Instead, at least one operand should be cast or promoted to the final type before the operation takes place.

## Noncompliant Code Example


    static void Main()
    {
      decimal dec = 3/2; // Noncompliant
      Method(3/2); // Noncompliant
    }
    
    static void Method(float f) { }


## Compliant Solution


    static void Main()
    {
      decimal dec = (decimal)3/2;
      Method(3.0F/2);
    }
    
    static void Method(float f) { }


## See

- [MITRE, CWE-190](http://cwe.mitre.org/data/definitions/190) - Integer Overflow or Wraparound
- [CERT, NUM50-J.](https://www.securecoding.cert.org/confluence/x/woIyAQ) - Convert integers to floating point for floating-point<br>  operations
- [CERT, INT18-C.](https://www.securecoding.cert.org/confluence/x/AxE) - Evaluate integer expressions in a larger size before<br>  comparing or assigning to that size
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat2) - Risky Resource Management

