
Properties with only setters are confusing and counterintuitive. Instead, a property getter should be added if possible, or the property should be replaced with a setter method.

## Noncompliant Code Example


    class Program
    {
        public int Foo  //Non-Compliant
        {
            set
            {
                // ... some code ...
            }
        }
    }


## Compliant Solution


    class Program
    {
        private int foo;
    
        public void SetFoo(int value)
        {
            // ... some code ...
            foo = value;
        }
    }


or


    class Program
    {
      public int Foo { get; set; } // Compliant
    }

