
Having a variable with the same name in two unrelated classes is fine, but do the same thing within a class hierarchy and you'll get confusion at best, chaos at worst.

## Noncompliant Code Example


    public class Fruit
    {
      protected Season ripe;
      protected Color flesh;
    
      // ...
    }
    
    public class Raspberry : Fruit
    {
      private bool ripe; // Noncompliant
      private static Color FLESH; // Noncompliant
    }


## Compliant Solution


    public class Fruit
    {
      protected Season ripe;
      protected Color flesh;
    
      // ...
    }
    
    public class Raspberry : Fruit
    {
      private bool ripened;
      private static Color FLESH_COLOR;
    }


## Exceptions

This rule ignores same-name fields that are `static` in both the parent and child classes. It also ignores `private` parent class fields, but in all other such cases, the child class field should be renamed.


    public class Fruit
    {
      private Season ripe;
      // ...
    }
    
    public class Raspberry : Fruit
    {
      private Season ripe;  // Compliant as parent field 'ripe' is anyway not visible from Raspberry
      // ...
    }

