
When exceptions occur, it is usually a bad idea to simply ignore them. Instead, it is better to handle them properly, or at least to log them.

This rule only reports on empty catch clauses that catch generic `Exception`s.

## Noncompliant Code Example


    string text = "";
    try
    {
        text = File.ReadAllText(fileName);
    }
    catch (Exception exc) // Noncompliant
    {
    }


## Compliant Solution


    string text = "";
    try
    {
        text = File.ReadAllText(fileName);
    }
    catch (Exception exc)
    {
        logger.Log(exc);
    }


## Exceptions

When a block contains a comment, it is not considered to be empty.

## See

- [OWASP Top 10 2017 Category A10](https://www.owasp.org/index.php/Top_10-2017_A10-Insufficient_Logging%26Monitoring) - Insufficient<br>  Logging & Monitoring
- [MITRE, CWE-391](http://cwe.mitre.org/data/definitions/391.html) - Unchecked Error Condition

