
Conditional expressions which are always `true` or `false` can lead to dead code. Such code is always buggy and should never be used in production.

## Noncompliant Code Example


    public void Sample(bool b)
    {
        bool a = false;
        if (a) // Noncompliant
        {
            DoSomething(); // never executed
        }
    
        if (!a || b) // Noncompliant; "!a" is always "true", "b" is never evaluated
        {
            DoSomething();
        }
        else
        {
            DoSomethingElse(); // never executed
        }
    
        var d = "xxx";
        var res = d ?? "value"; // Noncompliant, d is always not null, "value" is never used
    }


## Compliant Solution


    public void Sample(bool b)
    {
        bool a = false;
        if (Foo(a))
        {
            DoSomething();
        }
    
        if (b)
        {
            DoSomething();
        }
        else
        {
            DoSomethingElse();
        }
    
        var d = "xxx";
        var res = d;
    }


## Exceptions

This rule will not raise an issue in either of these cases:

- When the condition is a single `const bool`



    const bool debug = false;
    //...
    if (debug)
    {
      // Print something
    }


- When the condition is the literal `true` or `false`.


In these cases it is obvious the code is as intended.

## See

- [MITRE, CWE-570](http://cwe.mitre.org/data/definitions/570.html) - Expression is Always False
- [MITRE, CWE-571](http://cwe.mitre.org/data/definitions/571) - Expression is Always True
- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed

