
If a boolean expression doesn't change the evaluation of the condition, then it is entirely unnecessary, and can be removed. If it is gratuitous because it does not match the programmer's intent, then it's a bug and the expression should be fixed.

## Noncompliant Code Example


    public void Sample(bool b, bool c, string s)
    {
        var a = true;
        if (a) // Noncompliant
        {
            DoSomething();
        }
    
        if (b &amp;&amp; a) // Noncompliant; "a" is always "true"
        {
            DoSomething();
        }
    
        if (c || !a) // Noncompliant; "!a" is always "false"
        {
            DoSomething();
        }
    
        string d = null;
        var v1 = d ?? "value"; // Noncompliant, d is always null
        var v2 = s ?? d; // Noncompliant, d is always null and the produced value is always equal to s. The condition to check the value of s is gratuitous.
    }


## Compliant Solution


    public void Sample(bool b, bool c, string s)
    {
        var a = true;
        if (Foo(a))
        {
            DoSomething();
        }
    
        if (b)
        {
            DoSomething();
        }
    
        if (c)
        {
            DoSomething();
        }
    
        var v1 = "value";
        var v2 = s;
    }


## See

- MISRA C:2004, 13.7 - Boolean operations whose results are invariant shall not be permitted.
- MISRA C:2012, 14.3 - Controlling expressions shall not be invariant
- [MITRE, CWE-571](http://cwe.mitre.org/data/definitions/571) - Expression is Always True
- [MITRE, CWE-570](http://cwe.mitre.org/data/definitions/570) - Expression is Always False
- [MITRE, CWE-489](http://cwe.mitre.org/data/definitions/489) - Leftover Debug Code
- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed

