
When the second and third operands of a ternary operator are the same, the operator will always return the same value regardless of the condition. Either the operator itself is pointless, or a mistake was made in coding it.

## Noncompliant Code Example


    public bool CanVote(Person person)
    {
      return person.GetAge() &gt; 18 ? true : true; // Noncompliant; is this what was intended?
    }


## Compliant Solution


    public bool CanVote(Person person)
    {
      return person.GetAge() &gt; 18 ? true : false;
      // or even better:
      // return person.GetAge() &gt; 18;
    }


## Deprecated

This rule is deprecated; use {rule:csharpsquid:S3923} instead.
