
The standard assertions library methods such as `AreEqual` and `AreSame` in **MSTest** and **NUnit**, or `Equal` and `Same` in **XUnit**, expect the first argument to be the expected value and the second argument to be the actual value. Swap them, and your test will still have the same outcome (succeed/fail when it should) but the error messages will be confusing.

This rule raises an issue when the second argument to an assertions library method is a hard-coded value and the first argument is not.

## Noncompliant Code Example


    Assert.AreEqual(runner.ExitCode, 0, "Unexpected exit code");  // Noncompliant; Yields error message like: Expected:&lt;-1&gt;. Actual:&lt;0&gt;.


## Compliant Solution


    Assert.AreEqual(0, runner.ExitCode, "Unexpected exit code");

