
A method is detected as test method if marked with one of the following attributes `[TestMethod]` or `[DataTestMethod]` (for mstest), `[Fact]` or `[Theory]` (for xunit) or `[Test]`, `[TestCase]`, `[TestCaseSource]` or `[Theory]` (for nunit). However, whether or not they have a test attribute, non-`public` methods are not recognized as tests, and therefore not executed. Neither are `async` `void` methods, or methods with generics anywhere in their signatures.

## Noncompliant Code Example


    [TestMethod]
    void TestNullArg()  // Noncompliant; method is not public
    {  /* ... */  }
    
    [TestMethod]
    public async void MyIgnoredTestMethod()  // Noncompliant; this is an 'async void' method
    { /* ... */ }
    
    [TestMethod]
    public void MyIgnoredGenericTestMethod&lt;T&gt;(T foo)  // Noncompliant; method has generics in its signature
    { /* ... */ }


## Compliant Solution


    [TestMethod]
    public void TestNullArg()
    {  /* ... */  }


## Exceptions

Accessibility is ignored for xUnit `Fact` test methods, since they do not need to be `public`.

`[Theory]` test methods in xUnit and `[TestCase]` and `[TestCaseSource]` test methods in nunit can be generic.
