
Numbers can be shifted with the `<<` and `>>` operators, but the right operand of the operation needs to be an `int` or a type that has an implicit conversion to `int`. However, with `dynamic`, the compiler's type checking is turned off, so you can pass anything to a shift operator and have it compile. And if the argument can't be converted to `int` at runtime, then a `RuntimeBinderException` will be raised.

## Noncompliant Code Example


    dynamic d = 5;
    var x = d &gt;&gt; 5.4; // Noncompliant
    x = d &gt;&gt; null; // Noncompliant
    x &lt;&lt;= new object(); // Noncompliant

