
`NotImplementedException` is often used to mark methods which must be implemented for the overall functionality to be complete, but which the developer wants to implement later. That's as opposed to the `NotSupportedException` which is thrown by methods which are required by base classes or interfaces, but which are not appropriate to the current class.

This rule raises an exception when `NotImplementedException` is thrown.

## Noncompliant Code Example


    void doTheThing()
    {
        throw new NotImplementedException();
    }


## Exceptions

Exceptions derived from `NotImplementedException` are ignored.
