
The point of having custom exception types is to convey more information than is available in standard types. But custom exception types must be `public` for that to work.

If a method throws a non-public exception, the best you can do on the caller's side is to `catch` the closest `public` base of the class. That is, you lose all that custom information you created the exception type to pass.

## Noncompliant Code Example


    internal class MyException : Exception   // Noncompliant
    {
      // ...
    }


## Compliant Solution


    public class MyException : Exception
    {
      // ...
    }


## Exceptions

This rule ignores Exception types that are not derived directly from `System.Exception`, `System.SystemException`, or `System.ApplicationException`.

## See

- [OWASP Top 10 2017 Category A10](https://www.owasp.org/index.php/Top_10-2017_A10-Insufficient_Logging%26Monitoring) - Insufficient<br>  Logging & Monitoring

