
A thread acquiring a lock on an object that can be accessed across application domain boundaries runs the risk of being blocked by another thread in a different application domain. Objects that can be accessed across application domain boundaries are said to have weak identity. Types with weak identity are:

- `MarshalByRefObject`
- `ExecutionEngineException`
- `OutOfMemoryException`
- `StackOverflowException`
- `String`
- `MemberInfo`
- `ParameterInfo`
- `Thread`


## Noncompliant Code Example


    using System;
    using System.Threading;
    
    namespace MyLibrary
    {
      class Foo
      {
        string myString = "foo";
    
        void Bar()
        {
          lock(myString) { } // Noncompliant
        }
      }
    }


## Compliant Solution


    using System;
    using System.Threading;
    
    namespace MyLibrary
    {
      class Foo
      {
        string myString = "foo";
        private readonly Object thisLock = new Object();
    
        void Bar()
        {
          lock(thisLock) { } // Compliant
        }
      }
    }

