
Changing an inherited member to `private` will not prevent access to the base class implementation.

This rule raises an issue when a `private` method in an unsealed type has a signature that is identical to a `public` method declared in a base type.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void SomeMethod(int count) { }
      }
      public class Bar:Foo
      {
        private void SomeMethod(int count) { } // Noncompliant
      }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void SomeMethod(int count) { }
      }
      public sealed class Bar : Foo
      {
        private void SomeMethod(int count) { }
      }
    }

