
When a method in a derived class has the same name as a method in the base class but with a signature that only differs by types that are weakly derived (e.g. `object` vs `string`), the result is that the base method becomes hidden.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      class Foo
      {
        internal void SomeMethod(string s1, string s2) { }
      }
    
      class Bar : Foo
      {
        internal void SomeMethod(string s1, object o2) { }  // Noncompliant
      }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
      class Foo
      {
        internal void SomeMethod(string s1, string s2) { }
      }
    
      class Bar : Foo
      {
        internal void SomeOtherMethod(string s1, object o2) { }
      }
    }

