
When a type name matches the name of a publicly defined namespace, for instance one in the .NET framework class library, it leads to confusion and makes the library that much harder to use.

This rule raises an issue when a name of a public type matches the name of a .NET Framework namespace, or a namespace of the project assembly, in a case-insensitive comparison.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      public class Text   // Noncompliant: Collides with System.Text
      {
      }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
      public class MyText
      {
      }
    }

