
When a reference parameter (keyword `ref`) is used, the passed argument type must exactly match the reference parameter type. This means that to be able to pass a derived type, it must be cast and assigned to a variable of the proper type. Use of generic methods eliminates that cumbersome down casting and should therefore be preferred.

This rule raises an issue when a method contains a `ref` parameter of type `System.Object`.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void Bar(ref object o1, ref object o2) // Noncompliant
        {
        }
      }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public void Bar&lt;T&gt;(ref T ref1, ref T ref2)
        {
        }
      }
    }

