
When a `System.Globalization.CultureInfo` or `IFormatProvider` object is not supplied, the default value that is supplied by the overloaded member might not have the effect that you want in all locales.

You should supply culture-specific information according to the following guidelines:

- If the value will be displayed to the user, use the current culture. See `CultureInfo.CurrentCulture`.
- If the value will be stored and accessed by software (persisted to a file or database), use the invariant culture. See<br>  `CultureInfo.InvariantCulture`.
- If you do not know the destination of the value, have the data consumer or provider specify the culture.


This rule raises an issue when a method or constructor calls one or more members that have overloads that accept a `System.IFormatProvider` parameter, and the method or constructor does not call the overload that takes the `IFormatProvider` parameter. This rule ignores calls to .NET Framework methods that are documented as ignoring the `IFormatProvider` parameter as well as the following methods:

- `Activator.CreateInstance`
- `ResourceManager.GetObject`
- `ResourceManager.GetString`


## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
        public class Foo
        {
            public void Bar(String string1)
            {
                if(string.Compare(string1, string2, false) == 0) // Noncompliant
                {
                    Console.WriteLine(string3.ToLower()); // Noncompliant
                }
            }
        }
    }


## Compliant Solution


    using System;
    using System.Globalization;
    
    namespace MyLibrary
    {
        public class Foo
        {
            public void Bar(String string1, String string2, String string3)
            {
                if(string.Compare(string1, string2, false,
                                  CultureInfo.InvariantCulture) == 0)
                {
                    Console.WriteLine(string3.ToLower(CultureInfo.CurrentCulture));
                }
            }
        }
    }


## Exceptions

This rule will not raise an issue when the overload is marked as obsolete.
