
The .NET framework class library provides methods for retrieving custom attributes. Sealing the attribute eliminates the search through the inheritance hierarchy, and can improve performance.

This rule raises an issue when a public type inherits from `System.Attribute`, is not abstract, and is not sealed.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
        [AttributeUsage(AttributeTargets.Class|AttributeTargets.Struct)]
        public class MyAttribute: Attribute // Noncompliant
        {
            private string nameValue;
            public MyAttribute(string name)
            {
                nameValue = name;
            }
    
            public string Name
            {
                get
                {
                    return nameValue;
                }
            }
        }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
        [AttributeUsage(AttributeTargets.Class|AttributeTargets.Struct)]
        public sealed class MyAttribute: Attribute
        {
            private string nameValue;
            public MyAttribute(string name)
            {
                nameValue = name;
            }
    
            public string Name
            {
                get
                {
                    return nameValue;
                }
            }
        }
    }

