
[Strong cipher algorithms](https://en.wikipedia.org/wiki/Strong_cryptography) are cryptographic systems resistant to cryptanalysis, they are not vulnerable to well-known attacks like brute force attacks for example.

It is recommended to use only cipher algorithms intensively tested and promoted by the cryptographic community.

## Noncompliant Code Example


    var tripleDES1 = new TripleDESCryptoServiceProvider(); // Noncompliant: Triple DES is vulnerable to meet-in-the-middle attack
    
    var simpleDES = new DESCryptoServiceProvider(); // Noncompliant: DES works with 56-bit keys allow attacks via exhaustive search
    
    var RC2 = new RC2CryptoServiceProvider(); // Noncompliant: RC2 is vulnerable to a related-key attack


## Compliant Solution


    var AES = new AesCryptoServiceProvider(); // Compliant


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [MITRE, CWE-327](http://cwe.mitre.org/data/definitions/327.html) - Use of a Broken or Risky Cryptographic Algorithm
- [CERT, MSC61-J.](https://www.securecoding.cert.org/confluence/x/VwAZAg) - Do not use insecure or weak cryptographic algorithms
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses

