
The use of increment and decrement operators in method calls or in combination with other arithmetic operators is not recommended, because:

- It can significantly impair the readability of the code.
- It introduces additional side effects into a statement, with the potential for undefined behavior.
- It is safer to use these operators in isolation from any other arithmetic operators.


## Noncompliant Code Example


    u8a = ++u8b + u8c--;
    foo = bar++ / 4;


## Compliant Solution

The following sequence is clearer and therefore safer:


    ++u8b;
    u8a = u8b + u8c;
    u8c--;
    foo = bar / 4;
    bar++;


## See

- [CERT, EXP30-C.](https://www.securecoding.cert.org/confluence/x/ZwE) - Do not depend on the order of evaluation for side effects<br>
- [CERT, EXP50-CPP.](https://www.securecoding.cert.org/confluence/x/fYAyAQ) - Do not depend on the order of evaluation for side<br>  effects
- [CERT, EXP05-J.](https://www.securecoding.cert.org/confluence/x/yQC7AQ) - Do not follow a write by a subsequent write or read of the<br>  same object within an expression

