
The name of a parameter in an externally visible method override does not match the name of the parameter in the base declaration of the method, or the name of the parameter in the interface declaration of the method or the name of any other `partial` definition.

## Noncompliant Code Example


    partial class Point
    {
      partial void MoveVertically(int z);
    }
    
    partial class Point
    {
      int x = 0;
      int y = 0;
      int z = 0;
    
      partial void MoveVertically(int y)  // Noncompliant
      {
        this.y = y;
      }
    }
    
    interface IFoo
    {
      void Bar(int i);
    }
    
    class Foo : IFoo
    {
      void Bar(int z) // Noncompliant, parameter name should be i
      {
      }
    }


## Compliant Solution


    partial class Point
    {
      partial void MoveVertically(int z);
    }
    
    partial class Point
    {
      int x = 0;
      int y = 0;
      int z = 0;
    
      partial void MoveVertically(int z)
      {
        this.z = z;
      }
    }
    
    interface IFoo
    {
      void Bar(int i);
    }
    
    class Foo : IFoo
    {
      void Bar(int i)
      {
      }
    }


## See

- [CERT, DCL40-C.](https://www.securecoding.cert.org/confluence/x/cwGTAw) - Do not create incompatible declarations of the same<br>  function or object

