
If Finalize or an override of Finalize throws an exception, and the runtime is not hosted by an application that overrides the default policy, the runtime terminates the process immediately without graceful cleanup (finally blocks and finalizers are not executed). This behavior ensures process integrity if the finalizer cannot free or destroy resources.

The rule reports on throw statements used in finalizers.

## Noncompliant Code Example


    Class MyClass
        Protected Overrides Sub Finalize()
            Throw New NotImplementedException() ' Noncompliant
        End Sub
    End Class


## Compliant Solution


    Class MyClass
        Protected Overrides Sub Finalize()
            ' No throw
        End Sub
    End Class

