
A long parameter list can indicate that a new structure should be created to wrap the numerous parameters or that the procedure is doing too many things.

## Noncompliant Code Example

With a maximum number of 3 parameters:


    Public Sub Foo(ByVal p1 As Integer, ByVal p2 As Integer, ByVal p3 As Integer, ByVal p4 As Integer) ' Noncompliant
      ' ...
    End Sub
    
    Public Function Bar(ByVal p1 As Integer, ByVal p2 As Integer, ByVal p3 As Integer, ByVal p4 As Integer) ' Noncompliant
      ' ...
    End Function


## Compliant Solution


    Public Sub Foo(ByVal p1 As Integer, ByVal p2 As Integer, ByVal p3 As Integer)
      ' ...
    End Sub
    
    Public Function Bar(ByVal p1 As Integer, ByVal p2 As Integer, ByVal p3 As Integer)
      ' ...
    End Function

