
Sharing some naming conventions is a key point to make it possible for a team to efficiently collaborate.

This rule allows to check that all interface names match a provided regular expression.

The default configuration is the one recommended by Microsoft:

- Must start with an upper case 'I' character, e.g. IFoo
- Followed by Pascal casing, starting with an upper case character, e.g. IEnumerable
- Short abbreviations of 2 letters can be capitalized, e.g. IFooID
- Longer abbreviations need to be lower cased, e.g. IFooHtml


## Noncompliant Code Example

With the default regular expression `^I([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`:


    Interface Foo  ' Noncompliant
    End Interface


## Compliant Solution


    Interface IFoo ' Compliant
    End Interface

