
Sharing some naming conventions is a key point to make it possible for a team to efficiently collaborate.This rule checks that all local variables follow a naming convention.

The default configuration is:

- Camel casing, starting with a lower case character, e.g. backColor
- Short abbreviations of 2 letters can be capitalized only when not at the beginning, e.g. id, productID
- Longer abbreviations need to be lower cased, e.g. html


## Noncompliant Code Example

With the default regular expression `^[a-z][a-z0-9]*([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`:


    Module Module1
        Sub Main()
            Dim Foo = 0 ' Noncompliant
        End Sub
    End Module


## Compliant Solution


    Module Module1
        Sub Main()
            Dim foo = 0 ' Compliant
        End Sub
    End Module

