
While it is technically correct to assign to parameters from within method bodies, doing so before the parameter value is read is likely a bug. Instead, initial values of parameters should be, if not treated as `readonly` then at least read before reassignment.

## Noncompliant Code Example


    Module Module1
        Sub Foo(ByVal a As Integer)
            a = 42                  ' Noncompliant
        End Sub
    End Module


## Compliant Solution


    Module Module1
        Sub Foo(ByVal a As Integer)
            Dim tmp = a
            tmp = 42
        End Sub
    End Module


## Exceptions

`ByRef` parameters are ignored.


    Module Module1
        Sub Foo(ByRef a As Integer)
            a = 42                  ' Ignored; it is a ByRef parameter
        End Sub
    End Module

