
The requirement for a final `Case Else` clause is defensive programming.

This clause should either take appropriate action or contain a suitable comment as to why no action is taken.

## Noncompliant Code Example


    Select Case param ' Noncompliant - Case Else clause is missing
      Case 0
        DoSomething()
      Case 1
        DoSomethingElse()
    End Select


## Compliant Solution


    Select Case param
      Case 0
        DoSomething()
      Case 1
        DoSomethingElse()
      Case Else ' Compliant
        DoSomethingElse()
    End Select


## See

- [MITRE, CWE-478](http://cwe.mitre.org/data/definitions/478.html) - Missing Default Case in Switch Statement
- [CERT, MSC01-C.](https://www.securecoding.cert.org/confluence/x/YgE) - Strive for logical completeness

